@extends('layouts.admin')

@section('content')
    <!-- Page Header -->
    <div class="py-6 bg-[#F6F6F6] border-b border-[#CBB4B0]">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold text-gray-900">Edit Partner</h1>
                    <p class="text-gray-600 mt-1">{{ $partner->name }}</p>
                </div>
                <div class="flex items-center space-x-4">
                    <a href="{{ route('admin.partners.index') }}" 
                       class="bg-[#8B8B8B] text-white px-4 py-2 rounded-none hover:bg-[#192D50] transition duration-150">
                        Kembali
                    </a>
                    <a href="{{ route('admin.partners.show', $partner) }}" 
                       class="bg-[#192D50] text-white px-4 py-2 rounded-none hover:bg-[#8B8B8B] transition duration-150">
                        Detail
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="py-8 bg-[#F6F6F6]">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                <div class="p-6">
                    <form method="POST" action="{{ route('admin.partners.update', $partner) }}" class="space-y-6">
                        @csrf
                        @method('PUT')
                        
                        <!-- Basic Information -->
                        <div class="bg-[#F6F6F6] p-6 rounded-none border border-[#CBB4B0]">
                            <h3 class="text-lg font-medium text-gray-900 mb-4">Informasi Dasar</h3>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="name" class="block text-sm font-medium text-gray-700 mb-2">Nama Partner</label>
                                    <input type="text" id="name" name="name" value="{{ old('name', $partner->name) }}" required
                                           class="w-full px-3 py-2 border border-gray-300 rounded-none focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('name')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="code" class="block text-sm font-medium text-gray-700 mb-2">Kode Partner</label>
                                    <input type="text" id="code" name="code" value="{{ old('code', $partner->code) }}" required
                                           class="w-full px-3 py-2 border border-gray-300 rounded-none focus:ring-indigo-500 focus:border-indigo-500"
                                           placeholder="Contoh: KS001, RS002">
                                    @error('code')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="email" class="block text-sm font-medium text-gray-700 mb-2">Email</label>
                                    <input type="email" id="email" name="email" value="{{ old('email', $partner->email) }}" required
                                           class="w-full px-3 py-2 border border-gray-300 rounded-none focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('email')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="phone" class="block text-sm font-medium text-gray-700 mb-2">Telepon</label>
                                    <input type="text" id="phone" name="phone" value="{{ old('phone', $partner->phone) }}" required
                                           class="w-full px-3 py-2 border border-gray-300 rounded-none focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('phone')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Contact Information -->
                        <div class="bg-[#F6F6F6] p-6 rounded-none border border-[#CBB4B0]">
                            <h3 class="text-lg font-medium text-gray-900 mb-4">Informasi Kontak</h3>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="contact_person" class="block text-sm font-medium text-gray-700 mb-2">Contact Person</label>
                                    <input type="text" id="contact_person" name="contact_person" value="{{ old('contact_person', $partner->contact_person) }}" required
                                           class="w-full px-3 py-2 border border-gray-300 rounded-none focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('contact_person')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="status" class="block text-sm font-medium text-gray-700 mb-2">Status</label>
                                    <select id="status" name="status" required
                                            class="w-full px-3 py-2 border border-gray-300 rounded-none focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                        <option value="">Pilih Status</option>
                                        <option value="active" {{ old('status', $partner->status) == 'active' ? 'selected' : '' }}>Active</option>
                                        <option value="inactive" {{ old('status', $partner->status) == 'inactive' ? 'selected' : '' }}>Inactive</option>
                                    </select>
                                    @error('status')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>

                            <div class="mt-6">
                                <label for="address" class="block text-sm font-medium text-gray-700 mb-2">Alamat</label>
                                <textarea id="address" name="address" rows="3" required
                                           class="w-full px-3 py-2 border border-gray-300 rounded-none focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">{{ old('address', $partner->address) }}</textarea>
                                @error('address')
                                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <!-- Security Information -->
                        <div class="bg-[#F6F6F6] p-6 rounded-none border border-[#CBB4B0]">
                            <h3 class="text-lg font-medium text-gray-900 mb-4">Informasi Keamanan</h3>
                            <div>
                                <label for="password" class="block text-sm font-medium text-gray-700 mb-2">Password Baru</label>
                                <input type="password" id="password" name="password"
                                       class="w-full px-3 py-2 border border-gray-300 rounded-none focus:ring-indigo-500 focus:border-indigo-500"
                                       placeholder="Kosongkan jika tidak ingin mengubah password">
                                @error('password')
                                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                @enderror
                                <p class="text-sm text-gray-500 mt-1">
                                    Kosongkan jika tidak ingin mengubah password. Password lama akan tetap digunakan.
                                </p>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="flex items-center justify-end space-x-4">
                            <a href="{{ route('admin.partners.show', $partner) }}" 
                               class="px-4 py-2 border border-[#8B8B8B] rounded-none text-sm font-medium text-[#8B8B8B] hover:bg-[#8B8B8B] hover:text-white transition duration-150">
                                Batal
                            </a>
                            <button type="submit" 
                                    class="px-6 py-2 bg-[#192D50] text-white rounded-none text-sm font-medium hover:bg-[#8B8B8B] transition duration-150">
                                Update Partner
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
